/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.block.crops;

import com.renyigesai.immortalers_delight.block.ReapCropBlock;
import com.renyigesai.immortalers_delight.entities.projectile.GasCloudEntity;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightMobEffect;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightParticleTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class KwatWheatCrop
extends ReapCropBlock {
    private static final BooleanProperty POISON = BooleanProperty.m_61465_((String)"poison");
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0)};

    public KwatWheatCrop(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)POISON, (Comparable)Boolean.valueOf(true)));
    }

    protected ItemLike m_6404_() {
        return (ItemLike)ImmortalersDelightItems.KWAT_WHEAT_SEEDS.get();
    }

    public VoxelShape m_5940_(BlockState p_51330_, BlockGetter p_51331_, BlockPos p_51332_, CollisionContext p_51333_) {
        return SHAPE_BY_AGE[this.m_52305_(p_51330_)];
    }

    public List<ItemStack> m_49635_(BlockState p_287732_, LootParams.Builder p_287596_) {
        return super.m_49635_(p_287732_, p_287596_);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pPos, Entity pEntity) {
        int age;
        super.m_7892_(state, level, pPos, pEntity);
        if (pEntity instanceof LivingEntity && (age = ((Integer)state.m_61143_((Property)f_52244_)).intValue()) == 7) {
            if (((Boolean)state.m_61143_((Property)POISON)).booleanValue() && ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)pEntity)) {
                this.makeAreaOfEffectCloud(level, pPos);
            } else {
                List list = level.m_45976_(LivingEntity.class, new AABB(pPos).m_82377_(3.0, 3.0, 3.0));
                if (!list.isEmpty()) {
                    for (LivingEntity livingentity : list) {
                        if (livingentity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ImmortalersDelightItems.GOLDEN_FABRIC_VEIL.get())) continue;
                        livingentity.m_6469_(level.m_269111_().m_269325_(), 2.0f);
                        livingentity.m_7292_(new MobEffectInstance((MobEffect)ImmortalersDelightMobEffect.GAS_POISON.get(), 120, 1));
                    }
                }
            }
            this.spawnParticle(level, pPos);
            level.m_7731_(pPos, (BlockState)((BlockState)state.m_61124_((Property)f_52244_, (Comparable)Integer.valueOf(5))).m_61124_((Property)POISON, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void m_5707_(@NotNull Level pLevel, @NotNull BlockPos pPos, BlockState pState, @NotNull Player pPlayer) {
        if (((Boolean)pState.m_61143_((Property)POISON)).booleanValue() && (Integer)pState.m_61143_((Property)f_52244_) == 7) {
            this.makeAreaOfEffectCloud(pLevel, pPos);
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (((Boolean)state.m_61143_((Property)POISON)).booleanValue() && (Integer)state.m_61143_((Property)f_52244_) >= 3) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vec3 = new Vec3((double)((float)pos.m_123341_() + serverLevel.f_46441_.m_188501_()), (double)((float)pos.m_123342_() + serverLevel.f_46441_.m_188501_()), (double)((float)pos.m_123343_() + serverLevel.f_46441_.m_188501_()));
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ImmortalersDelightParticleTypes.KWAT.get()), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1, 0.0, 0.0, 0.0, 0.025);
                }
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    private void spawnParticle(Level level, BlockPos pPos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 center = new Vec3((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5);
            double radius = 3.3;
            for (int i = 0; i < 32; ++i) {
                double angle = Math.PI * 2 * Math.random();
                double r = radius * Math.sqrt(Math.random());
                double x = center.f_82479_ + r * Math.cos(angle);
                double z = center.f_82481_ + r * Math.sin(angle);
                double y = center.f_82480_;
                if (r <= radius / 3.0) {
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ImmortalersDelightParticleTypes.GAS_SMOKE.get()), x, y, z, 1, 0.0, 0.0, 0.0, 0.025);
                    continue;
                }
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ImmortalersDelightParticleTypes.KWAT.get()), x, y, z, 1, 0.0, 0.0, 0.0, 0.025);
            }
        }
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7495_();
        if (pState.m_60734_() == this) {
            return pLevel.m_8055_(blockpos).canSustainPlant((BlockGetter)pLevel, blockpos, Direction.UP, (IPlantable)this);
        }
        return this.m_6266_(pLevel.m_8055_(blockpos), (BlockGetter)pLevel, blockpos);
    }

    protected boolean m_6266_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return pState.m_60713_(Blocks.f_50135_) || pState.m_60713_(Blocks.f_50136_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_52244_, POISON});
    }

    private void makeAreaOfEffectCloud(Level level, BlockPos pPos) {
        if (level.m_5776_()) {
            return;
        }
        GasCloudEntity effectCloud = new GasCloudEntity(level, pPos.m_123341_(), pPos.m_123342_(), pPos.m_123343_());
        effectCloud.setRadius(3.0f);
        effectCloud.setRadiusOnUse(-0.1f);
        effectCloud.setWaitTime(10);
        effectCloud.setRadiusPerTick(-(effectCloud.getRadius() / (float)effectCloud.getDuration()) * 3.0f);
        effectCloud.setParticle((ParticleOptions)ImmortalersDelightParticleTypes.KWAT.get());
        effectCloud.addEffect(new MobEffectInstance((MobEffect)ImmortalersDelightMobEffect.GAS_POISON.get(), 320, 1));
        level.m_7967_((Entity)effectCloud);
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        float f;
        int i;
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        if (pLevel.m_45524_(pPos, 0) >= 9 && (i = this.m_52305_(pState)) < this.m_7419_() && ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.m_188503_((int)(25.0f / (f = KwatWheatCrop.m_52272_((Block)this, (BlockGetter)pLevel, (BlockPos)pPos))) + 1) == 0 ? 1 : 0) != 0)) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(i + 1)), 2);
            ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public void m_52263_(Level pLevel, BlockPos pPos, BlockState pState) {
        int j;
        int q = (Boolean)pState.m_61143_((Property)POISON) != false || pLevel.f_46441_.m_188503_(5) < 3 ? this.m_7125_(pLevel) : 1;
        int i = this.m_52305_(pState) + q;
        if (i > (j = this.m_7419_())) {
            i = j;
        }
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(i)), 2);
    }
}

